function optifit =fitfun(param,depth2,Cld)

% fitfun -	calculates the difference between the model output and the measured pore fluid data profile 
%			This file is called by the optimalresults function.

%_______________________________________________________________________________________
% written by: Heleen Vanneste - part of PhD thesis (November 2010)
%			  National Oceanography Centre, Southampton
%			  University of Southampton, United Kingdom
%_______________________________________________________________________________________

%% Read data - calling input file
carl = [49502];
for m=1:length(carl)
    filename=num2str(carl(m));
    infile = strcat(filename,'.txt');
    fid = fopen(infile);
    tline = fgets(fid);
    tline = fgets(fid);
    [d c] = fscanf(fid,'%f');
    ibad = find(d==-9999);
    d(ibad)=NaN*ones(size(ibad));
    fclose(fid);
    par    =3;						% total number of columns in file
    depth = d(2 : par : c);			% the number refers to column number in inputfile
    Cl    = d(3 : par : c);			% chloride		
    %Na    = d(3 : par : c);		% sodium
    %B     = d(4 : par : c);		% boron
    clear d; 
end

xmax= 110; dx=1; x=[0:dx:xmax];		%length of core; sample interval

%% Cl
% Adjust the length of model to the length of the measured data profile
mout =feval(@fluidflow_model,param);
Clf  = mout(end,0*length(x)+1:1*length(x));
[a b]=ismember(x,fliplr(depth));
clear b
Clm=Clf(a);
size (Clm);
depth2=depth(1:max(size(Clm)));
Cld = Cl(1:max(size(Clm)));

% Calculate difference between modelled and measured data point
optifit= Clm' - Cld;			%Clm=model result; Cld=meaured data 

%% B
% Adjust the length of model to the length of the measured data profile
% mout=feval(@fluidflow_model,param);
% Bf = mout(end,1*length(x)+1:2*length(x));
% [a b]=ismember(x,fliplr(depth));
% clear b
% Bm=Bf(a);
% size (Bm);
% depth2=depth(1:max(size(Bm)));
% Bd = B(1:max(size(Bm)));

% Calculate difference between modelled and measured data point
% optifit= Bm' - Bd;

%% Na
% Adjust the length of model to the length of the measured data profile
% mout=feval(@fluidflow_model,param);
% Naf = mout(end,3*length(x)+1:4*length(x));
% [a b]=ismember(x,fliplr(depth));
% clear b
% Nam=Naf(a);
% size (Nam);
% depth2=depth(1:max(size(Nam)));
% Nad = Na(1:max(size(Nam)));

% Calculate difference between modelled and measured data point
% optifit= Nam' - Nad;