function optimalresults

% Optimalresults -  Nonlinear least-squares fit of a given function to data (lsqnonlin).
%                    Necessary files to run this function: fitfun.m, fitstat.m and fluidflow_model.m 


%_______________________________________________________________________________________
% written by: (1) Heleen Vanneste - part of PhD thesis (November 2010)
%			  National Oceanography Centre, Southampton
%			  University of Southampton, United Kingdom
%
%			  (2) Matthias Haeckel
%			  IFM-GEOMAR, Kiel, Germany
%_______________________________________________________________________________________

clear all; clf;
global x 

%% Read data -  calling input file
carl = [49502];
for m=1:length(carl)
    filename=num2str(carl(m));
    infile = strcat(filename,'.txt');
    fid = fopen(infile);
    tline = fgets(fid);
    tline = fgets(fid);
    [d c] = fscanf(fid,'%f');
    ibad = find(d==-9999);
    d(ibad)=NaN*ones(size(ibad));
    fclose(fid);
    par    = 3;                     % total number of columns in file
    depth = d(2 : par : c);         % the number refers to column number in inputfile
    length (depth)                  %gives length of depth
    Cl    = d(3 : par : c);
    %Na    = d(3: par : c);
    %B     = d(4 : par : c)
    clear d; 
end

% Adjustment of depth - Note depth interval of the data needs to match depth interval of measured data 
depth2=depth(1:20); 
Cld = Cl(1:20);
%Bd=B(1:22);
%Nad=Na(1:13);

% fitting parameters - starting values
vent = 2;                    % upward fluid flow, u [cm/yr]
param = [vent];

% lower and upper limit for fitparameters
low=[0];
up=[50];

%-----------------------------------------------------------------------------------------------------------
%% Cl
%non-linear data fitting
options=[];%optimset('Diagnostics','off','Display','iter','TolFun',1e-15);
[fitparam,chi,res,exitflag,output,lam,jac]=...
    lsqnonlin(@fitfun,param,low,up,options,depth2,Cld);

%fit output
confparam = nlparci(fitparam,res,real(jac))
errparam = confparam(:,2)-rot90(fitparam,-1) % 2-sigma standard deviation


disp('Initial values for parameters')
disp(param)

%fit statistics
[cov R sigma r2]=...
    fitstat(fitparam,res+Cld,Cld,jac);

% save results
%save statsfitCl49_13 param low up fitparam res confparam cov R sigma r2

%-----------------------------------------------------------------------------------------------------------
%% B
%non-linear data fitting
% options=[];%optimset('Diagnostics','off','Display','iter','TolFun',1e-15);
% [fitparam,chi,res,exitflag,output,lam,jac]=...
%     lsqnonlin(@fitfun,param,low,up,options,depth2,Bd);
% 
% 
% %fit output
% confparam = nlparci(fitparam,res,real(jac))
% errparam = confparam(:,2)-rot90(fitparam,-1) % 2-sigma standard deviation
% 
%  disp('Initial values for parameters')
%  disp(param)
% 
% %fit statistics
% [cov R sigma r2]=...
%     fitstat(fitparam,res+Bd,Bd,jac);
% 
% save results
% save statsfitB49_14 param low up fitparam chi res confparam cov R sigma r2

%-----------------------------------------------------------------------------------------------------------
%% Na
%non-linear data fitting
% options=[];%optimset('Diagnostics','off','Display','iter','TolFun',1e-15);
% [fitparam,chi,res,exitflag,output,lam,jac]=...
%     lsqnonlin(@fitfun,param,low,up,options,depth2,Nad);
% 
% %fit output
% confparam = nlparci(fitparam,res,real(jac))
% errparam = confparam(:,2)-rot90(fitparam,-1) % 2-sigma standard deviation
%  
% disp('Initial values for parameters')
% disp(param)
% 
% %fit statistics
% [cov R sigma r2]=...
%     fitstat(fitparam,res+Nad,Nad,jac);
% 
% save results
% save statsfitNa49_15 param low up fitparam chi res confparam cov R sigma r2
