% LRA - Low-Rank Approximation.
% [PH,LH] = LRA(D,M)
% Finads optimal solution to the problem: 
% Minimize over DH norm(D - DH, 'fro') subject to rank(DH) <= M
%
% D  - data matrix of dimension qxN, q < N
% M  - rank constraint, M < q
% PH, LH - PH*LH is the rank-m approximation DH of D
function [p,l] = lra(d,m)

d(isnan(d)) = 0; % Convert missing elements (NaNs) to 0s
[q,N] = size(d); % matrix dimension

if nargout == 1 
  d = triu(qr(d'))'; % = R,  where D = QR
  d = d(:,1:q);      % = R1, where R = [R1 0]
end
[u,s,v] = svds(d,m);
p = u(:,1:m); % basis for the optimal model for D
if nargout == 2
  s = diag(s); % column vector
  l = s(1:m,ones(1,N)) .* v(:,1:m)'; % diag(S) * V'
end
