% This function normalises each column of the data passed on to the
% function and returns the normalised data to the range (if provided) else 
% [0,1] and the min max for each column
% 
% USAGE: [NData, range] = normaliseData(Data);
% Data            - Data passed on to the function
% Ndata           - Normalised data with columns normalised
% range           - min and max of each column that can be used for
%                 - following processing
% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)
% Date: 16 Nov 2008

function [NData, range] = normaliseData(Data,range);

m = size(Data,2);
NData = [];
epsi = 0.00001; % for division with zero

if (nargin <2) % no range is provided
    range = [];
    for i=1:m
        t = Data(:,i);

        mn = min(t);
        mx = max(t);

        NData = [NData (t-mn)/((mx-mn)+epsi)];
        range = [range [mn;mx]];
    end
else           % if range is already given
    for i=1:m
        t = Data(:,i);

        mn = range(1,i);
        mx = range(2,i);

        NData = [NData (t-mn)/((mx-mn)+epsi)];
        %range = [range [mn;mx]];
    end
    
end