function [gtruth, prdLbl, prd, acc] = siCVOvR(upsample, ...
                                            Data, ...
                                            Lbl, ...
                                            wavname, ...
                                            database, ...
                                            classifier, ...
											options, ...
                                            method, ...
                                            IWscheme);
                                        
                                        
% 
% This function applies speaker independent (is) cross validation on 
% multiclass data by using a classifier supplied in classifier parameter. 
% For SVM the method uses LibSVM or SRG based upon the option method
% 
% [gtruth, prdLbl, prd, acc] = siCVOvR(upsample, ...
%                                         Data, ...
%                                         Lbl, ...
%                                         wavname, ...
%                                         database, ...
%                                         classifier, ...
% 										  options, ...
%                                         IWscheme);
% 
% 
% upsample = true/false Note: results in paper are produced with 
%             upsample = false
% Data     = input data
% Lbl      = class lbl
% wavname  = name of the input files for extracting speakers
% database = name of the database so that the script can separate speakers:
%            options are: 'DES' , 'Berlin' , 'Serbian'
% classifier = 'svm' (default) , 'kNN' , 'naiveBayes'
% options  = options for the classifier (optional)
% IWscheme = method for calculating 
%            'kmm'
%            'kliep'
%            'ulsif'
%            default = ones
% 
% gtruth = contains the true labels of the data. This will be different
%          from Lbl which is passed to the function as input parameter. 
%          It is different because of stratified cross validation
% prdLbl = predicted labels
% prd    = probabilities of each pridiction from SVMs
% acc    = [UAR WAR] accuracy per fold is this order
% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)

if nargin < 5 fprintf('Please give enough parameters'); help siCVOvR; return; end
if nargin < 6 classifier = 'svm'; end
if nargin < 7 options = 0.1; end
if nargin < 8 IWscheme = 'none'; end

classifier = 'svm';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Separating the different speakers
switch lower(database)
    case 'des'
%         dw - Female
%         hw - Male
%         jw - Male
%         kw - Female
        [speaker] = unique(wavname(:,1));
        for i=1:length(speaker)
            speakeridx(:,i) = speaker(i) == wavname(:,1);
        end
    case 'berlin'
        [speaker] = unique(str2num(wavname(:,1:2)));
        for i=1:length(speaker)
            speakeridx(:,i) = speaker(i) == str2num(wavname(:,1:2));
        end
    case 'serbian'
%       SK
%       MV
%       MM
%       SZ
%       OK
%       BM
        [speaker] = ['sk';'mv';'mm';'sz';'ok';'bm'];
        for i=1:length(speaker)
            speakeridx(:,i) =  floor(sum( ...
                                repmat(speaker(i,:),[length(wavname) 1]) == ...
                                lower(wavname(:,1:2)) ...
                                   ,2) /2);
        end
    case 'aibomont'
        % 1,2,3,4, ...... 25
        [speaker] = 1:25;
        for i=1:length(speaker)
            speakeridx(:,i) = speaker(i) == str2num(wavname(:,6:7));
        end
        speakeridx(:,sum(speakeridx) == 0) = [];
    case 'aiboohm'
        % 1,2,3,4, ...... 32
        [speaker] = 1:32;
        for i=1:length(speaker)
            speakeridx(:,i) = speaker(i) == str2num(wavname(:,5:6));
        end
        speakeridx(:,sum(speakeridx) == 0) = [];
    case 'aiboall' % case when we have the whole database
        % separate Mont and Ohm and then look for speaker independently
        idx = wavname(:,1) == 'M';
        wavnameM = wavname(idx,:);
        % 1,2,3,4, ...... 25
        [speaker] = 1:25;
        for i=1:length(speaker)
            speakeridxM(:,i) = speaker(i) == str2num(wavnameM(:,6:7));
        end
        speakeridxM(:,sum(speakeridxM) == 0) = [];
        clear speaker
        
        wavnameO = wavname(~idx,:);
        % 1,2,3,4, ...... 32
        [speaker] = 1:32;
        for i=1:length(speaker)
            speakeridxO(:,i) = speaker(i) == str2num(wavnameO(:,5:6));
        end
        speakeridxO(:,sum(speakeridxO) == 0) = [];
        
        speakeridx = [speakeridxM zeros(size(speakeridxM,1),size(speakeridxO,2));
                    zeros(size(speakeridxO,1),size(speakeridxM,2)) speakeridxO];
    otherwise
        error('Unidentified database name');
end

k = size(speakeridx,2); % for speaker independent

gtruth = [];    % Original Label
gtruth2 = [];    % Original Label
prdLbl = [];    % Predicted Label
prd = [];       % Prediction Probability
prd2 = [];       % Prediction Probability
acc = [];

t = cputime;

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Running the CV on per speaker
for i=1:k
    fprintf('Working on speaker %i .... \n',i);
	
	teIdx = logical(speakeridx(:,i));
    trIdx = ~speakeridx(:,i);
    
    teData = Data(teIdx,:);
    teLbl = Lbl(teIdx,:);
    
    trData = Data(trIdx,:);
    trLbl = Lbl(trIdx,:);
	
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [gt,pLbl,p] = OvRSvmsSRG(upsample, ...
                                trData,...
                                trLbl,...
                                teData, ...
                                teLbl, ...
                                options, ...
                                IWscheme);
    
    gtruth = [gtruth; gt];
    prdLbl = [prdLbl; pLbl];
    prd = [prd;p];
    
    c = confusionmat(gt,pLbl);
    acc(i,1) = UAR(teLbl,pLbl);
    acc(i,2) = WAR(teLbl,pLbl);
end
	
confusionmat(gtruth, prdLbl)

time = cputime - t

end	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	