function [cov R sigma r2]=fitstat(fitparam,yfit,ydata,jac)

% FITSTAT - Calculate regression statistics from optimalresults.m
%     output:
%     sigma    - standard deviation of each parameter
%     cov      - covariance matrix parameters
%     R        - Correlation matrix for Parameters
%     r2	   - R^2 Correlation coefficient of fit
%     
%     input:
%     fitparam	- parameter values of least squares fit
%     yfit	    - result of nonlinear least squares fit using param 
%                 (yfit=residual+ydata) 
%     ydata	    - data points
%     jac	    - Jacobian of least squares fit (Dyfit/Dparam)
%

%_______________________________________________________________________________________
% written by: (1) Heleen Vanneste - part of PhD thesis (November 2010)
%			  National Oceanography Centre, Southampton
%			  University of Southampton, United Kingdom
%		and	  (2) Matthias Haeckel
%			  IFM-GEOMAR, Kiel, Germany
%_______________________________________________________________________________________


%% PARAMETER STATISTICS

% covariance matrix
jac=full(jac);
cov=inv(jac'*jac);
ExpCovariance=cov;
% correlation matrix and standard deviation on parameters
%[ExpSigma, ExpCorrC] = cov2corr(ExpCovariance);
[R,sigma] = corrcov(cov);


%% FITCURVE STATISTICS
%Calculate R^2 (Ref Draper & Smith p.46)
cor2=corrcoef(ydata(:),yfit(:));
r2=cor2(1,2).^2;


%% DISPLAY
disp('Parameter Statistics')

disp('Least Squares Estimates of Parameters')
disp(real(fitparam))

disp('standard deviation on parameters')
disp(real(sigma)')

disp('Correlation matrix for parameters')
disp(real(R))

disp('Curve fitting Statistics')
disp('Linear correlation coefficient of fitcurve => r^2')
disp(real(r2))



