package linMap;


import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;

import linMap.cellLineage.LineageParams;
import linMap.cxMap.CxMapParams;
import linMap.geneNetwork.NetworkParams;

/**
 * A <code>ControlFrame</code> object contains the primary LinMap controls,
 * including network and lineage parameters and controls that affect the 
 * global state of the visualisation model.
 * 
 * @author nic
 *
 */
public class ControlFrame extends JFrame {

	/**
	 * Constructs a new <code>ControlFrame</code> and populates it with
	 * a <code>ControlPanel</code> and menu bar.
	 * @param cxMapStack
	 * 			the visualisation model
	 * @param cxMapParams
	 * 			the complexity map parameters
	 * @param linParams
	 * 			the cell lineage parameters
	 * @param netParams
	 * 			the gene network parameters
	 */
	public ControlFrame(CxMapStack cxMapStack, CxMapParams cxMapParams,
			LineageParams linParams, NetworkParams netParams) {

		this.setTitle("LinMap - Cell Lineage Viewer"); 
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		cp = new ControlPanel(cxMapStack, cxMapParams, linParams, netParams);
		cp.setMinimumSize(new Dimension(300, 100));
		
		cp.setPreferredSize(new Dimension(400, 400));
		cp.setMaximumSize(new Dimension(400, 400));
		
		this.getContentPane().add(cp);
		this.createMenuBar();

		this.pack();
		this.setVisible(true);
	}
	
	/**
	 * Accessor or the <code>ControlPanel</code> object contained by this frame.
	 * @return the <code>ControlPanel</code> object.
	 */
	public ControlPanel getControlPanel() {
		return cp;
	}
	
	private void createMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		
		JMenu fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
		menuBar.add(fileMenu);
		
		JMenuItem loadItem = new JMenuItem("Load Map", KeyEvent.VK_L);
		loadItem.addActionListener(cp.new FileAction());
		loadItem.setActionCommand("loadmap");
		fileMenu.add(loadItem);
		
		JMenuItem saveItem = new JMenuItem("Save Map", KeyEvent.VK_L);
		saveItem.addActionListener(cp.new FileAction());
		saveItem.setActionCommand("savemap");
		fileMenu.add(saveItem);
		
		JMenu viewMenu = new JMenu("View");
		viewMenu.setMnemonic(KeyEvent.VK_V);
		menuBar.add(viewMenu);
		
		JMenuItem newMapItem = new JMenuItem("New Map View", KeyEvent.VK_N);
		newMapItem.addActionListener(new ViewAction());
		newMapItem.setActionCommand("newmapview");
		viewMenu.add(newMapItem);
		
		this.setJMenuBar(menuBar);
	}

	/**
	 * A <code>ViewAction</code> creates a new heat map view of the model.
	 * Initially, this map view has the same settings as the current
	 * active map view.
	 * 
	 * @author nic
	 *
	 */
	public class ViewAction implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String command = e.getActionCommand();
			if (command == "newmapview") {
				LinMap.createNewMapFrame();
			}
		}
	}
	
	private static final long serialVersionUID = 1992291367570335629L;		
	private ControlPanel cp;

}
