package linMap;

import java.awt.*;
import linMap.cxMap.CxBlock.ComplexityType;

/**
 * The <code>CxColour</code> class provides functionality for converting
 * complexity values into a colour gradient.
 * 
 * NOTE: This class requires work to enable different gradients for 
 * different complexity measures.
 * 
 * @author nic
 *
 */
public class CxColour {

	public CxColour(ComplexityType curCxType, double cxMax) {
		grad = new Gradient();
		setCxType(curCxType, cxMax);
	}
	
	public Paint getMax(){
		Color c = maxColour;
		return c;
	}
	
	public Paint getMin(){
		Color c = minColour;
		return c;
	}
	
	public void setCxType(ComplexityType curCxType, double cxMax) {
		minColour = new Color(0, 0, 0);
		maxColour = curCxType.getColour();
		grad.reset();
		grad.addPoint(minColour);
		grad.addPoint(maxColour);
		grad.createGradient();		
	}
	
	public Paint getColour(double cx) {
//		float r = 0;
//		float g = 0;
//		if (cx > 0) 
//			g = (float)(cx * 0.6 + 0.4);
//		float b = 0;
//		Color c = new Color(r, g, b);
//		Color c = grad.getColour((int)(cx * 256));
//		return c;
		if (cx > 0)
			cx = cx * 0.6 + 0.4;
		return grad.getColour((int)(cx * 255));
	}
	
	Color minColour;
	Color maxColour;
	Gradient grad;
	
}
