package linMap;

import java.awt.*;
import java.awt.geom.*;

import javax.swing.*;

/**
 * A <code>CxScalePanel</code> object displays a gradient of <code>CxColour</code>
 * defined colours in the range [cxMin, cxMax].
 * 
 * @author nic
 *
 */
public class CxScalePanel extends JPanel {

	/**
	 * Construct a new <code>CxScalePanel</code>.
	 * @param cxMin
	 * 			the minimum complexity value
	 * @param cxMax
	 * 			the maximum complexity value
	 */
	public CxScalePanel(CxColour colours) {
		this.colours = colours;
	}

	public void updateColours(CxColour colours) {
		this.colours = colours;
		repaint();
	}
	
	public void paintComponent(Graphics g) {
		Graphics2D g2 = (Graphics2D)g;
		
		g2.setPaint(new GradientPaint(0, 0, (Color)colours.getMax(),
				getWidth(), getHeight(), (Color)colours.getMin()));
		Rectangle2D bg = new Rectangle2D.Float(0, 0, getWidth(), getHeight());
		g2.fill(bg);		
	}

	private static final long serialVersionUID = -3184309470269216550L;

	private CxColour colours;
}
