package linMap;

import java.awt.geom.Point2D;
import java.util.*;

import linMap.cellLineage.*;

/**
 * A <code>FocusLineageEvent</code> indicates that the focus of the currently active 
 * <code>MapPanel</code> has changed.  The event is passed to every
 * <code>FocusLineageListener</code> object that registered to receive such events
 * using the component's <code>addFocusLineageListener</code> method. 
 * 
 * @author nic
 *
 */
public class FocusLineageEvent extends EventObject {
	
	/**
	 * Construct a new <code>FocusLineageEvent</code>
	 * @param source
	 * 			the object that originated the event
	 * @param currentLoc
	 * 			the current normalised location of the focus
	 * @param currentParams
	 * 			the parameter coordinates of the focus
	 * @param lin
	 * 			the cell lineage at the current focus
	 * @param complexity
	 * 			the complexity of the cell lineage at the current focus
	 */
	public FocusLineageEvent(Object source, 
			Point2D currentLoc, Point2D currentParams, 
			Lineage lin, double complexity) {
		super(source);
		this.currentLoc = currentLoc;
		this.currentParams = currentParams;
		this.lin = lin;
		this.complexity = complexity;
	}
	
	public Lineage lineage() {
		return lin;
	}
	
	public Point2D currentParams() {
		return currentParams;
	}
	
	public Point2D currentLoc() {
		return currentLoc;
	}
	
	public double complexity() {
		return complexity;
	}
	
	private static final long serialVersionUID = 6025076339263489961L;

	private Point2D currentLoc = new Point2D.Double();
	private Point2D currentParams = new Point2D.Double();
	
	private Lineage lin;
	private double complexity;
	
}
