package linMap;

/**
 * The listener interface for receiving <code>FocusLineageEvents</code>.  The class that 
 * is interested in processing an action event implements this interface, and the object 
 * created with that class is registered with a component, using the component's 
 * <code>addFocusLineageListener</code> method. When the action event occurs, that object's 
 * <code>focusLineageRecieved</code> method is invoked.
 * 
 * @author nic
 *
 */
public interface FocusLineageListener {
	/**
	 * Invoked when the focus is changed.
	 */
	public void focusLineageReceived(FocusLineageEvent event);
}
