package linMap;

import javax.swing.*;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * An <code>InfoPanel</code> object displays information on a currently 
 * displayed cell lineage.  It listens for <code>FocusLineageEvents</code>
 * and updates accordingly.
 * 
 * NOTE: Currently only the complexity value corresponding to the currently
 * active map is shown.  It may be desirably to show multiple complexity 
 * values.
 * 
 * @author nic
 *
 */
public class InfoPanel extends JPanel implements FocusLineageListener {

	/**
	 * Construct a new <code>InfoPanel</code>.
	 */
	public InfoPanel() {
		// construct components	
		JLabel weightLabel = new JLabel("Weight Factor: ");
		weightValueLabel = new JLabel();
		JLabel lambdaLabel = new JLabel("Lambda: ");
		lambdaValueLabel = new JLabel();
		JLabel cxLabel = new JLabel("Complexity: ");
		cxValueLabel = new JLabel();
		
		// layout components
		FormLayout layout = new FormLayout(
				"right:pref, 3dlu, fill:pref:grow, 6dlu, right:pref, 3dlu, " +
				"fill:pref:grow, 6dlu, right:pref, 3dlu, fill:pref:grow,",
				"p");

		layout.setColumnGroups(new int[][]{{}});
		layout.setRowGroups(new int[][]{{}});
		
		PanelBuilder builder = new PanelBuilder(layout, this);
		builder.setDefaultDialogBorder();
		
		CellConstraints cc = new CellConstraints();
		
		builder.add(weightLabel, 				cc.xy(1, 1));
		builder.add(weightValueLabel,			cc.xy(3, 1));
		builder.add(lambdaLabel, 				cc.xy(5, 1));
		builder.add(lambdaValueLabel,			cc.xy(7, 1));
		builder.add(cxLabel, 					cc.xy(9, 1));
		builder.add(cxValueLabel,				cc.xy(11, 1));
	}

	public synchronized void focusLineageReceived(FocusLineageEvent e) {
		int tmp = (int)(e.currentParams().getX() * PREC_TWO);
		weightValueLabel.setText(Double.toString(tmp/PREC_TWO));
		tmp = (int)(e.currentParams().getY() * PREC_TWO);
		lambdaValueLabel.setText(Double.toString(tmp/PREC_TWO));
		tmp = (int)(e.complexity() * PREC_TWO);
		cxValueLabel.setText(Double.toString(tmp/PREC_TWO));
	}
	
	private static final long serialVersionUID = -1138819044862429518L;

	private static final double PREC_TWO = 100.0;
	
	private JLabel weightValueLabel;
	private JLabel lambdaValueLabel;
	private JLabel cxValueLabel;
	
}
