package linMap;

import java.util.*;


import javax.swing.*;

import linMap.cellLineage.*;
import linMap.cxMap.*;
import linMap.geneNetwork.*;

import com.jgoodies.looks.plastic.*;

/**
 * The main entry point for the LinMap program.  Also provides static functions for
 * managing multiple map views.
 * 
 * @author nic
 *
 */
public class LinMap {
	
	public static void main(String[] args) {
		try {
			   UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
		} catch (Exception e) {}
		
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
	}

	/**
	 * Construct and show the basic parameter objects, visualisation model and view and 
	 * controller components.
	 */
	private static void createAndShowGUI() {
		cxMapParams = new CxMapParams(0.2, 1.8, 0.1, 0.0, 1.0, 4);
		linParams = new LineageParams(6, 0.8);
		netParams = new NetworkParams(2, 12, 5, -74533470, 1.4);
		cxMapStack = new CxMapStack(new ComplexityMap(cxMapParams, linParams, netParams));
		
		mapList = new ArrayList<MapBorderPanel>();

		cf = new ControlFrame(cxMapStack, cxMapParams, linParams, netParams);
		lf = new LineageFrame(cxMapStack.getCurrentMap().getColumn(0).getBlock(0).getLin());
		createNewMapFrame();
		
		lf.setLocation(cf.getWidth(), 0);
		cf.setLocation(0, mapList.get(0).mf.getHeight()+25);
	}
	
	/**
	 * Creates a new <code>MapFrame</code> object and adds it to the current list.
	 */
	protected static void createNewMapFrame() {
		MapFrame mf = new MapFrame(cxMapStack);
		addMap(mf.getMapBorderPanel());
	}	

	/**
	 * Adds a new map view to the list of active map views that are currently linked to the 
	 * visualisation model.
	 * @param mbp
	 * 			the <code>MapBorderPanel</code> object to be added
	 */
	protected static void addMap(MapBorderPanel mbp) {
		// register all map panels as listeners for each other's events
		for (MapBorderPanel currentMap : mapList) {
			mbp.addFocusLineageListener(currentMap);
			mbp.addResetListener(currentMap);
			currentMap.addFocusLineageListener(mbp);
			currentMap.addResetListener(mbp);
		}
		mapList.add(mbp);	
		// register other panels as listeners for map panel events
		mbp.addFocusLineageListener(lf.getLineagePanel());
		mbp.addFocusLineageListener(lf.getInfoPanel());
		mbp.addContourListener(cf.getControlPanel());
		mbp.addSelectionListener(cf.getControlPanel());
		// register map panel as listener for model update events
		cxMapStack.addUpdateMapListener(mbp);
	}

	/**
	 * Removes a map view from the list of map views that are currently linked to the 
	 * visualisation model.  Note that the map is not actually destroyed - it continues
	 * to exist but it no longer sends or receives events.  It can subsequently be
	 * re-added to the active map list.
	 * @param mbp
	 * 			the <code>MapBorderPanel</code> object to be removed
	 */
	protected static void removeMap(MapBorderPanel mbp) {
		mapList.remove(mbp);
		for (MapBorderPanel currentMap : mapList) {
			mbp.removeFocusLineageListener(currentMap);
			mbp.removeResetListener(currentMap);
			currentMap.removeFocusLineageListener(mbp);
			currentMap.removeResetListener(mbp);
		}
	}
	
	private static CxMapParams cxMapParams;
	private static LineageParams linParams;
	private static NetworkParams netParams;
	private static CxMapStack cxMapStack;
	
	private static LineageFrame lf;
	private static ControlFrame cf;
	private static ArrayList<MapBorderPanel> mapList;
}
