package linMap;

import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.JFrame;

import linMap.cellLineage.Lineage;

/**
 * A <code>LineageFrame</code> object holds a <code>LineagePanel</code> and an
 * <code>InfoPanel</code>.
 * @author nic
 *
 */
public class LineageFrame extends JFrame {

	/**
	 * Constructs a new <code>LineageFrame</code> object.
	 * @param defaultLin
	 * 			the intial lineage to display
	 */
	public LineageFrame(Lineage defaultLin) {
		this.setTitle("Current Lineage");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		lp = new LineagePanel(defaultLin);
		lp.setMinimumSize(new Dimension(200, 150));
		lp.setPreferredSize(new Dimension(800, 600));
		
		ip = new InfoPanel();
		ip.setMinimumSize(new Dimension(350, 30));
		ip.setPreferredSize(new Dimension(350, 30));
		ip.setMaximumSize(new Dimension(2000, 30));
		Box vBoxRight = Box.createVerticalBox();
		vBoxRight.add(ip);
		vBoxRight.add(lp);
	
		this.getContentPane().add(vBoxRight);
		this.pack();
		this.setVisible(true);		
	}

	/**
	 * Accessor for the contained <code>LineagePanel</code>.
	 */
	public LineagePanel getLineagePanel() {
		return lp;
	}
	
	/**
	 * Accessor for the contained <code>InfoPanel</code>.
	 */
	public InfoPanel getInfoPanel() {
		return ip;
	}
	
	private static LineagePanel lp;
	private static InfoPanel ip;
	
	private static final long serialVersionUID = 1L;

}
