package linMap;


import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;

import javax.swing.*;

import linMap.cellLineage.*;
import linMap.geneNetwork.*;
import linMap.rulesets.nondeterministic.NonDeterministicRecursiveRuleSet;



public class LineagePanelStub {


	public static final int DEFAULT_WIDTH = 800;
	public static final int DEFAULT_HEIGHT = 600;
	
	private static LineageParams params;
	private static Network net;
	private static Lineage lin;

	private LineagePanel lp;
	
	public static void main(String[] args) {
		LineagePanelStub lps = new LineagePanelStub();
		lps.setUp();
		lps.testLineagePanelLineage();
	}
	
	protected void setUp() {
		params = new LineageParams();
		params.divDecay = 0.7;
		params.maxDepth = 8;
		Random generator = new Random(7585);
		net = NetTools.createSimpleRecurrentNet(2, 12, 5, generator, 1.4);
		lin = new Lineage(params, net);
		lin.generate();
	}

	public void testLineagePanelLineage() {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);


		lp = new LineagePanel(lin);
		frame.getContentPane().add(lp, BorderLayout.CENTER);

		JButton button = new JButton("New Seed");
		button.addActionListener(new SeedAction());
		frame.getContentPane().add(button, BorderLayout.SOUTH);

		frame.setVisible(true);
		lin.getZygote().getFate();
		NonDeterministicRecursiveRuleSet rs = new NonDeterministicRecursiveRuleSet(lin);
		rs.print();
//		lin.print(lin.getZygote());
	}

	private class SeedAction implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			System.out.println("button pressed...");
			Random generator = new Random();
			net = NetTools.createSimpleRecurrentNet(2, 12, 5, generator, 1.4);
			lin = new Lineage(params, net);
			lin.generate();	
			lp.setLineage(lin);
			lp.repaint();
		}

	}

}
