package linMap;

import java.awt.event.*;
import java.util.ArrayList;

import javax.swing.*;

import linMap.cxMap.CxBlock.ComplexityType;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/** 
 * A <code>MapButtonPanel</code> object provides several additional controls
 * for interacting with a <code>MapPanel</code>. 
 * @author nic
 *
 */
public class MapButtonPanel extends JPanel {

	/** 
	 * Constructs a new <code>MapButtonPanel</code> linked to a specific
	 * <code>MapBorderPanel</code>.
	 * 
	 * @param mbp
	 * 			the linked <code>MapBorderPanel</code> 
	 */
	public MapButtonPanel(MapBorderPanel mbp) {
		this.mbp = mbp;

		ArrayList<String> cxTypeStrings = new ArrayList<String>();
		for (ComplexityType cxType : ComplexityType.values())
			cxTypeStrings.add(cxType.toString());
		
		cxTypeList = new JComboBox(cxTypeStrings.toArray());
		cxTypeList.setMaximumRowCount(cxTypeStrings.size());
		cxTypeList.setSelectedIndex(1);
		cxTypeList.addActionListener(new CxTypeListener());
		
		LockAction la = new LockAction();
		lockButton = new JToggleButton(" Lock ");
		lockButton.addItemListener(la);

		BorderAction ba = new BorderAction();
		borderButton = new JToggleButton("Border");
		borderButton.addItemListener(ba);
		borderButton.setSelected(true);

		// layout components
		
		FormLayout layout = new FormLayout(
				"center:pref, 3dlu, center:pref, 3dlu, center:pref",
				"pref");
	
		layout.setColumnGroups(new int[][]{{3,5}});
		
		PanelBuilder builder = new PanelBuilder(layout, this);
		builder.setDefaultDialogBorder();
		
		CellConstraints cc = new CellConstraints();
		
		builder.add(cxTypeList, 		cc.xy(1, 1));
		builder.add(lockButton, 		cc.xy(3, 1));
		builder.add(borderButton,		cc.xy(5, 1));
		
	}

	class CxTypeListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			JComboBox cb = (JComboBox)e.getSource();
			String cxTypeString = (String)cb.getSelectedItem();
			mbp.updateCxType(ComplexityType.valueOf(ComplexityType.class, cxTypeString));
		}
	}
	
	class LockAction implements ItemListener {
		public void itemStateChanged(ItemEvent e) {
			int state = e.getStateChange();
			if (state == ItemEvent.SELECTED) {
				mbp.lockMap();
				lockButton.setText("Unlock");
			} else if (state == ItemEvent.DESELECTED) {
				mbp.unlockMap();
				lockButton.setText(" Lock ");
			}
		}
	}
	
	class BorderAction implements ItemListener {
		public void itemStateChanged(ItemEvent e) {
			int state = e.getStateChange();
			if (state == ItemEvent.SELECTED) {
				mbp.updateBorder(true);
			} else if (state == ItemEvent.DESELECTED) {
				mbp.updateBorder(false);
			}
		}
	}
	
	private static final long serialVersionUID = -781438452823809078L;
		
	private MapBorderPanel mbp;
	protected JComboBox cxTypeList;
	protected JToggleButton lockButton;
	protected JToggleButton borderButton;
}
