package linMap;

import java.awt.Dimension;
import javax.swing.JFrame;

/**
 * A <code>MapFrame</code> contains a single heat map instance, together with 
 * associated controllers.
 * @author nic
 *
 */
public class MapFrame extends JFrame {

	/**
	 * Construct a new <code>MapFrame</code> object.
	 * @param cxMapStack
	 * 			the visualisation model to which the frame is linked
	 */
	public MapFrame(CxMapStack cxMapStack) {

		this.setTitle("Current Map");
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

		mbp = new MapBorderPanel(this, cxMapStack);
		mbp.setPreferredSize(new Dimension(400, 350));

		this.getContentPane().add(mbp);
		this.pack();
		this.setVisible(true);		
	}
	
	/** 
	 * Accessor for the <code>MapBorderPanel</code> held by the frame.
	 * @return
	 * 			the <code>MapBorderPanel</code> held by the frame
	 */
	public MapBorderPanel getMapBorderPanel() {
		return mbp;
	}
	
	private static MapBorderPanel mbp;
	private static final long serialVersionUID = 1L;
}
