package linMap;

import java.awt.BorderLayout;
import javax.swing.*;

import linMap.cellLineage.*;
import linMap.cxMap.*;
import linMap.geneNetwork.*;

public class MapPanelStub {

	public static final int DEFAULT_WIDTH = 400;
	public static final int DEFAULT_HEIGHT = 400;
	
	private CxMapParams cxMapParams;
	private LineageParams linParams;
	private NetworkParams netParams;
	private ComplexityMap cxMap;
	
	private double lambdaMin = 0.0;
	private double lambdaMax = 1.0;
	private double weightMin = 0.2;
	private double weightMax = 1.8;
	private double weightStep = 0.02;
	private int lambdaDiv = 6;
	private MapPanel mp;
	
	public static void main(String[] args) throws Exception {
		MapPanelStub mps = new MapPanelStub();
		mps.setUp();
		mps.testMapPanelLineage();
	}

	protected void setUp() throws Exception {
		cxMapParams = new CxMapParams(weightMin, weightMax, weightStep, 
				lambdaMin, lambdaMax, lambdaDiv);
		linParams = new LineageParams(6, 0.8);
		netParams = new NetworkParams(2, 20, 3, 7627, 1.4);
		cxMap = new ComplexityMap(cxMapParams, linParams, netParams);
		cxMap.print();
	}


	public void testMapPanelLineage() {
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

//		mp = new MapPanel(linMap.cxMap);
		frame.getContentPane().add(mp, BorderLayout.CENTER);

		frame.setVisible(true);
	}

}
