package linMap;

import java.util.*;

import linMap.cxProfile.CxPoint;


/**
 * A <code>ProfileEvent</code> indicates that a profile has been selected within
 * the currently active <code>MapPanel</code>.  The event is passed to every
 * <code>ProfileListener</code> object that registered to receive such events
 * using the component's <code>addProfileListener</code> method. 
 * 
 * @author nic
 *
 */
public class ProfileEvent extends EventObject {

	
	/**
	 * Construct a new <code>ProfileEvent</code> object containing the start and end
	 * locations of the profile.
	 * @param source
	 * 			the object that originated the event
	 * @param start
	 * 			the start location of the profile
	 * @param end
	 * 			the end location of the profile
	 */
	public ProfileEvent(Object source, CxPoint start, CxPoint end) {
		super(source);
		this.start = start;
		this.end = end;
	}
		
	/**
	 * Accessor for the profile start point.
	 * @return the profile start point
	 */
	public CxPoint getStart() {
		return start;
	}

	/**
	 * Accessor for the profile end point.
	 * @return the profile end point
	 */
	public CxPoint getEnd() {
		return end;
	}
	
	private static final long serialVersionUID = 1L;
	private CxPoint start = null;
	private CxPoint end = null;
}
