package linMap;

/**
 * The listener interface for receiving <code>ProfileEvents</code>.  The class that is interested 
 * in processing an action event implements this interface, and the object created with 
 * that class is registered with a component, using the component's 
 * <code>addProfileListener</code> method. When the action event occurs, that object's 
 * <code>profileReceived</code> method is invoked.
 * 
 * @author nic
 *
 */
public interface ProfileListener {
	
	/**
	 * Invoked when a profile is defined.
	 */
	public void profileReceived(ProfileEvent event);
}
