package linMap;

import java.util.EventObject;

/**
 * A <code>ResetEvent</code> indicates that a new selection or profile has been
 * defined on the current map and that any existing selections or profiles on 
 * linked maps should be reset.  The event is passed to every
 * <code>ResetListener</code> object that registered to receive such events
 * using the component's <code>addResetListener</code> method.
 * 
 * @author nic
 *
 */
public class ResetEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	/**
	 * Construct a new <code>ResetEvent</code>.
	 * @param source
	 * 			the object that originated the event
	 */
	public ResetEvent(Object source) {
		super(source);
	}
}
