package linMap;

/**
 * The listener interface for receiving <code>ResetEvents</code>.  The class that is interested 
 * in processing an action event implements this interface, and the object created with 
 * that class is registered with a component, using the component's 
 * <code>addResetListener</code> method. When the action event occurs, that object's 
 * <code>resetReceived</code> method is invoked.
 * 
 * @author nic
 *
 */
public interface ResetListener {
	/**
	 * Invoked when a selection, contour or focus has been made in another map.
	 * @param event
	 */
	public void resetReceived(ResetEvent event);
}
