package linMap;

import java.util.*;

import linMap.cxMap.*;

/**
 * A <code>SelectionEvent</code> indicates that a selection has been defined 
 * on the currently active <code>MapPanel</code>.  The event is passed to every
 * <code>SelectionListener</code> object that registered to receive such events
 * using the component's <code>addSelectionListener</code> method.
 * 
 * @author nic
 *
 */
public class SelectionEvent extends EventObject {

	/**
	 * Construct a new <code>SelectionEvent</code>.
	 * @param source
	 * 			the object that originated the event
	 * @param newParams
	 * 			the complexity map parameters defined by the selected region
	 */
	public SelectionEvent(Object source, CxMapParams newParams) {
		super(source);
		params = newParams;
	}
	
	/**
	 * Accessor for the complexity map parameters sent by the <code>SelectionEvent</code>.
	 * @return the complexity map parameters defined by the selected region
	 */
	public CxMapParams params() {
		return params;
	}
	
	private static final long serialVersionUID = 2898693614507979903L;
	private CxMapParams params;
}
