package linMap;

/**
 * The listener interface for receiving <code>SelectionEvents</code>.  The class that is interested 
 * in processing an action event implements this interface, and the object created with 
 * that class is registered with a component, using the component's 
 * <code>addSelectionListener</code> method. When the action event occurs, that object's 
 * <code>selectionReceived</code> method is invoked.
 * 
 * @author nic
 *
 */
public interface SelectionListener {

	/**
	 * Invoked when a selection is defined.
	 */
	public void selectionReceived(SelectionEvent event);
}
