package linMap;

import java.util.*;

/**
 * An <code>UpdateMapEvent</code> indicates that the visualisation model 
 * has been updated, and any views may need to be updated accordingly.  
 * The event is passed to every <code>UpdateMapListener</code> object that 
 * registered to receive such events using the component's 
 * <code>addUpdateMapListener</code> method.
 * 
 * @author nic
 *
 */
public class UpdateMapEvent extends EventObject {
	
	/**
	 * Construct an <code>UpdateMapEvent</code>.
	 * @param source
	 * 			the object that originated the event
	 * @param recalculate
	 * 			<code>true</code> if the update will require the map parameters 
	 * 			to be recalculated; that is, if a new map has been added, or the 
	 * 			dimensions (eg number of columns) of the current map have changed
	 */
	public UpdateMapEvent(Object source, boolean recalculate) {
		super(source);
		this.recalculate = recalculate;
	}

	/**
	 * Accessor for the recalculate flag
	 * @return <code>true</code> if the map parameters need to be recalculated
	 */
	public boolean getRecalculate() {
		return this.recalculate;
	}

	private static final long serialVersionUID = -5422307301436359839L;
	private boolean recalculate;
	
}
