package linMap;

/**
 * The listener interface for receiving <code>UpdateMapEvents</code>.  The class that is interested 
 * in processing an action event implements this interface, and the object created with 
 * that class is registered with a component, using the component's 
 * <code>addUpdateMapListener</code> method. When the action event occurs, that object's 
 * <code>updateMapReceived</code> method is invoked.
 * 
 * @author nic
 *
 */
public interface UpdateMapListener {
	
	/**
	 * Invoked when the model is updated
	 */
	public void updateMapReceived(UpdateMapEvent event);
}
