package linMap.cellLineage;

import java.util.*;
import junit.framework.TestCase;
import linMap.cellLineage.Cell;
import linMap.geneNetwork.*;

public class CellTest extends TestCase {

	private ArrayList<Integer> id;
	private Network network;
	
	protected void setUp() throws Exception {
		super.setUp();
		id = new ArrayList<Integer>();
		id.add(Cell.ZYGOTE);
		id.add(Cell.LEFT);
		Random generator = new Random(1234);
		network = NetTools.createSimpleRecurrentNet(2, 3, 4, generator, 2.0);
	}

	/*
	 * Test method for 'linMap.cellLineage.Cell.Cell(ArrayList<Integer>, Network)'
	 */
	public void testCellArrayListOfIntegerNetwork() {
		Cell cell = new Cell(id, network);
		assertEquals((int)Cell.ZYGOTE, (int)cell.getId().get(0));
		assertEquals((int)Cell.LEFT, (int)cell.getId().get(1));
//		assertEquals(27, cell.getNetwork().getWeightCount());
	}

	/*
	 * Test method for 'linMap.cellLineage.Cell.Cell(Cell, int)'
	 */
	public void testCellCellInt() {
		Cell cell = new Cell(id, network);
		Cell cell2 = new Cell(cell, Cell.RIGHT);
		assertEquals((int)Cell.ZYGOTE, (int)cell2.getId().get(0));
		assertEquals((int)Cell.LEFT, (int)cell2.getId().get(1));
		assertEquals((int)Cell.RIGHT, (int)cell2.getId().get(2));
//		assertEquals(27, cell2.getNetwork().getWeightCount());
	}

	/*
	 * Test method for 'linMap.cellLineage.Cell.clone()'
	 */
	public void testClone() {
		double[] input = { 0.4, 0.5 };
		Cell cell = new Cell(id, network);
		cell.setInput(input);
		Cell cell2 = (Cell)cell.clone();
		double[] newInput = { 0.6, 0.7 };
		cell2.setInput(newInput);
//		assertEquals(0.4, cell.input[0], 1e-8);
	}
	
	public void testEquals() {
		Cell cell = new Cell(id, network);
		cell.terminal = true;
		Cell cell2 = new Cell(id, network);
		cell2.terminal = true;
		// test that two identical cells (different objects) are equal
		assertEquals(true, cell.equals(cell2));
		Cell cell3 = new Cell(cell2, Cell.RIGHT);
		cell3.terminal = true;
		// test that two cells with different IDs are NOT equal
		assertEquals(false, cell.equals(cell3));
		Cell cell4 = new Cell(id, network);
		cell4.activate(network);
		cell4.update(4, 0.1);
		cell4.terminal = true;
		cell4.differentiated = true;
		System.out.println(cell.getFate());
		System.out.println(cell4.getFate());
		// test that two cells with different fates are NOT equal
		assertEquals(false, cell.equals(cell4));
	}

}
