package linMap.cellLineage;

// Possibly should be a check at some point to ensure a terminal 
// cell never has multiple differentiation tags?

import java.util.*;

/**
 * A <code>Fate</code> object represents a cells fate as a set of differentiation
 * tags.  Differentiation tags include both the terminal/non-terminal state of a cell
 * and the range of possible fates into which a cell can develop. 
 * @author nic
 */
public class Fate implements Comparable<Fate>, Cloneable {

	public static final int ALLOFF = 0;
	public static final int TERM = (int)Math.pow(2, 0);
	public static final int NON_DIFF = 29;
	
	public int diff;
	
	public Fate() { 
		diff = ALLOFF;
	}
	
	public String toString() {
		return this.getClass().getName()
		+ "[diff=" + diff
		+ "]";
	}
	
	public void add(int id) {
		diff = diff | (int)Math.pow(2,id+1);
	}

	public void add(Fate fate) {
		diff = diff | fate.diff;
	}
	
	public void remove(int id) {
		diff = diff & ~(int)Math.pow(2,id+1);
	}
	
	public void setTerminal() {
		diff = diff | TERM;
	}
	
	public void setNonTerminal() {
		diff = diff & ~TERM;
	}
	
	public boolean terminal() {
		return ((diff & TERM) == TERM);
	}
	
	/**
	 * Obtain the differentiation tags associated with a fate.
	 * @return a set of possible differentiation fates
	 */
	public List<Integer> getDiff() {
		List<Integer> diffSet = new ArrayList<Integer>();
		for (int i=1; i<31; i++) {
			int curMask = (int)Math.pow(2, i);
			if ((diff & curMask) == curMask) {
				diffSet.add(i-1);
			}
		}
//		System.out.println(diffSet);
		return diffSet;
	}

	public int compareTo(Fate f) {
		if (diff < f.diff) 
			return -1;
		else
			return 1;
	}
	
	public boolean equals(Object otherObject) {
		if (this == otherObject) return true;
		if (otherObject == null) return false;
		if (this.getClass() != otherObject.getClass()) return false;
		Fate other = (Fate)otherObject;
		return this.diff == other.diff;
	}

	public int hashCode() {
		int result = 17;
		result = 37*result + diff;
		return result;
	}
	
	public Object clone() {
		Fate o = null;
		try {
			o = (Fate)super.clone();
		} catch (CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return o;	
	}
}
