package linMap.cellLineage;


import java.util.*;

import junit.framework.TestCase;
import linMap.cellLineage.Fate;

public class FateTest extends TestCase {

	private Fate fate;
	
	protected void setUp() throws Exception {
		super.setUp();
		fate = new Fate();
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.Fate()'
	 */
	public void testFate() {
		assertEquals(0, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.add(int)'
	 */
	public void testAddInt() {
		fate.add(1);
		assertEquals(4, fate.diff);
		fate.add(3);
		assertEquals(20, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.add(Fate)'
	 */
	public void testAddFate() {
		fate.add(1);
		assertEquals(4, fate.diff);
		Fate fate2 = new Fate();
		fate2.add(3);
		fate.add(fate2);
		assertEquals(20, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.remove(int)'
	 */
	public void testRemove() {
		fate.add(1);
		fate.add(3);
		fate.remove(1);			// check removing existing fate
		assertEquals(16, fate.diff);
		fate.remove(5);			// check that removing non-existant fate doesn't hurt
		assertEquals(16, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.setTerminal()'
	 */
	public void testSetTerminal() {
		fate.setTerminal();
		assertEquals(1, fate.diff);
		fate.add(1);
		assertEquals(5, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.setNonTerminal()'
	 */
	public void testSetNonTerminal() {
		fate.setTerminal();
		fate.add(1);
		fate.setNonTerminal();
		assertEquals(4, fate.diff);
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.terminal()'
	 */
	public void testTerminal() {
		fate.setTerminal();
		assertEquals(true, fate.terminal());
		fate.setNonTerminal();
		assertEquals(false, fate.terminal());
	}

	/*
	 * Test method for 'linMap.cellLineage.Fate.getDiff()'
	 */
	public void testGetDiff() {
		int[] values = { 1, 3, 7, 9 };
		for (int i=0; i<values.length; i++) {
			fate.add(values[i]);
		}
		fate.setTerminal();
		List<Integer> fateList = fate.getDiff();
		Collections.sort(fateList);
		assertEquals(values.length, fateList.size());
		for (int i=0; i<values.length; i++) {
			System.out.println(fateList.get(i));
			assertEquals(values[i], (int)fateList.get(i));
		}
	}

	public void testEquals() {
		fate.add(3);
		Fate fate2 = new Fate();
		fate2.add(3);
		boolean e = (fate.equals(fate2));
		assertEquals(true, e);
	}
	
	public void testNonDiff() {
		fate.add(Fate.NON_DIFF);
		System.out.println(fate);
		List<Integer> fateList = fate.getDiff();
		System.out.println(fateList.size());
		assertEquals((Integer)Fate.NON_DIFF, (Integer)fate.getDiff().get(0));
	}
	
}
