package linMap.cellLineage;

import junit.framework.*;
import linMap.cellLineage.Lineage;
import linMap.cellLineage.LineageParams;
import linMap.geneNetwork.*;

public class LineageTest extends TestCase {

	private LineageParams params;
	private NetworkParams netParams;
	
	protected void setUp() throws Exception {
		super.setUp();
		params = new LineageParams();
		params.divDecay = 0.8;
		params.maxDepth = 2;
		netParams = new NetworkParams();
		netParams.inputNodes = 2;
		netParams.hiddenNodes = 4;
		netParams.outputNodes = 3;
		netParams.seed = 123456;
		netParams.weightScale = 2.0;
	}
	
	/*
	 * Test method for 'linMap.cellLineage.Lineage.Lineage(LineageParams, Network)'
	 */
	public void testLineageLineageParamsNetwork() {
		Lineage lin = new Lineage(params, netParams);
		System.out.println(lin);
	}

	/*
	 * Test method for 'linMap.cellLineage.Lineage.Generate()'
	 */
	public void testGenerate() {
		Lineage lin = new Lineage(params, netParams);
		lin.generate();
		System.out.println(lin);
		lin.getZygote().getFate();
		System.out.println(lin);
	}

	public void testEquals() {
		Network net = NetTools.createSimpleRecurrentNet(netParams);
		Network net2 = (Network)net.clone();
		Lineage lin = new Lineage(params, net);
		Lineage lin2 = new Lineage(params, net2);
		lin.generate();
		lin2.generate();
//		assertEquals(net.toString(), net2.toString());
		assertEquals(true, lin.equals(lin2));
		
//		Random generator = new Random(16);
//		Network net3 = NetTools.createSimpleRecurrentNet(2, 6, 3, generator, 6.0);
		netParams.hiddenNodes = 6;
		netParams.seed = 16;
		netParams.weightScale = 6.0;
		Lineage lin3 = new Lineage(params, netParams);
//		Lineage lin3 = new Lineage(params, net3);
		lin3.generate();
		lin.getZygote().getFate();
		lin3.getZygote().getFate();
		lin.print();
//		lin3.print();
		lin.printState();
		assertEquals(false, lin.equals(lin3));
	}
	
}
