package linMap.cxMap;

import junit.framework.TestCase;
import linMap.cellLineage.*;
import linMap.cxMap.ComplexityMap;
import linMap.cxMap.CxMapParams;
import linMap.cxMap.CxBlock.ComplexityType;
import linMap.geneNetwork.*;

public class ComplexityMapTest extends TestCase {

	private CxMapParams cxMapParams;
	private LineageParams linParams;
	private NetworkParams netParams;
	private ComplexityMap cxMap;
	
	private double lambdaMin = 0.0;
	private double lambdaMax = 1.0;
	private double weightMin = 1.0;
	private double weightMax = 4.0;
	private double weightStep = 0.5;
	private int lambdaDiv = 3;
	
	protected void setUp() throws Exception {
		super.setUp();
		linParams = new LineageParams(6, 0.8);
		netParams = new NetworkParams(2, 12, 3, 1245, 1.4);
	}

	/*
	 * Test method for 'linMap.ComplexityMap.ComplexityMap(float, float, float, float, float, int, LineageParams, NetworkParams)'
	 */
	public void testComplexityMap() {
		cxMapParams = new CxMapParams(weightMin, weightMax, weightStep, 
				lambdaMin, lambdaMax, lambdaDiv);
		cxMap = new ComplexityMap(cxMapParams, linParams, netParams);
//		linMap.cxMap.print();
		cxMap.printWtScales();
		cxMap.subdivideWeights();
		cxMap.printWtScales();
	}

	public void testGetCxMax() {
		cxMapParams = new CxMapParams(weightMin, weightMax, weightStep, 
				lambdaMin, lambdaMax, lambdaDiv);
		cxMap = new ComplexityMap(cxMapParams, linParams, netParams);
		for (ComplexityType type : ComplexityType.values()) {
			System.out.println(type + " -- " + cxMap.getCxMax(type));
		}
	}
}
