package linMap.cxMap;

import java.io.*;

public class CxMapParams implements Cloneable, Serializable {
	
	private static final long serialVersionUID = 3972140160606956563L;

	public CxMapParams(double weightMin, double weightMax, double weightStep, double lambdaMin, double lambdaMax, int lambdaDiv) {
		this.weightMin = weightMin;
		this.weightMax = weightMax;
		this.weightStep = weightStep;
		this.lambdaMin = lambdaMin;
		this.lambdaMax = lambdaMax;
		this.lambdaDiv = lambdaDiv;
	}
	
	public CxMapParams() {}

	public void print() {
		System.out.println("weights: [" + weightMin + " -- " + weightMax + "] x " + weightStep);
		System.out.println("lambda : [" + lambdaMin + " -- " + lambdaMax + "] x " + lambdaDiv);
		System.out.println("columns: [" + colMinIndex + " -- " + colMaxIndex + "]");
	}
	
	public Object clone() {
		CxMapParams result = null;
		try {
			result = (CxMapParams)super.clone();
		} catch(CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return result;
	}
	
	public double weightMin;
	public double weightMax;
	public double weightStep;
	public double lambdaMin;
	public double lambdaMax;
	public int lambdaDiv;
	
	public int colMinIndex;
	public int colMaxIndex;
}
