package linMap.cxProfile;

import linMap.cellLineage.Lineage;
import linMap.cellLineage.LineageParams;
import linMap.geneNetwork.NetTools;
import linMap.geneNetwork.Network;
import linMap.geneNetwork.NetworkParams;
import linMap.rulesets.nondeterministic.NonDeterministicRecursiveRuleSet;

public class CxEntry {
	public CxPoint pointMin;
	public CxPoint pointMax;
	
//	private LineageParams linParams;
//	private NetworkParams netParams;
	
	public Lineage lin;
	public double complexity;
	
	public CxEntry(CxPoint pointMin, CxPoint pointMax, LineageParams linParams, NetworkParams netParams) {
		this.pointMin = pointMin;
		this.pointMax = pointMax;
		netParams.weightScale = pointMin.wtScale;
		linParams.divDecay = pointMin.lambda;
//		this.linParams = linParams;
//		this.netParams = netParams;
		
		Network net = NetTools.createSimpleRecurrentNet(netParams);
		lin = new Lineage(linParams, net);
		lin.generate();
		NonDeterministicRecursiveRuleSet ndrs = new NonDeterministicRecursiveRuleSet(lin);
		this.complexity = ndrs.getWeightedComplexity();
	}
}