package linMap.cxProfile;

import java.util.ArrayList;
import java.io.*;

import linMap.cellLineage.LineageParams;
import linMap.cxMap.CxMapParams;
import linMap.geneNetwork.NetworkParams;


public class CxProfile {
	private CxPoint start;
	private CxPoint end;
	private int divisions;
	
	private double totalDistance;
	
	private LineageParams linParams;
	private NetworkParams netParams;
	
	private ArrayList<CxEntry> entries;
	
	public CxProfile(CxMapParams cxMapParams, LineageParams linParams, 
			NetworkParams netParams, CxPoint start, CxPoint end, int divisions) {
		this.linParams = linParams;
		this.netParams = netParams;
		this.start = start;
		this.end = end;
		this.divisions = divisions;
		this.totalDistance = this.calculateDistance(this.end, this.start);
		entries = new ArrayList<CxEntry>();
		entries.add(createCxEntry(this.start, this.end));
		entries.add(createCxEntry(this.end, this.end));
		subdivideEntries(0, this.divisions);
	}
	
	public void writeCx(PrintWriter out) {
		for (CxEntry entry : this.entries) {
			out.println(
					normalisePoint(entry.pointMin) + "," +
					normalisePoint(entry.pointMax) + "," +
//					entry.pointMin.wtScale + "," +
//					entry.pointMin.lambda + "," +
					entry.complexity);
		}
		out.close();
	}
	
	private double normalisePoint(CxPoint point) {
		return calculateDistance(point, this.start) / this.totalDistance;
	}
	
	private double calculateDistance(CxPoint pointMin, CxPoint pointMax) {
		double d = Math.sqrt(
				Math.pow(pointMax.lambda - pointMin.lambda, 2.0) + 
				Math.pow(pointMax.wtScale - pointMin.wtScale, 2.0));
		return d;
	}
	
	private CxEntry createCxEntry(CxPoint pointMin, CxPoint pointMax) {
		CxEntry entry = new CxEntry(pointMin, pointMax, linParams, netParams);
		return entry;
	}
	
	private CxPoint computeMidpoint(CxPoint a, CxPoint b) {
		double wtScale = 0.0;
		double lambda = 0.0;
		wtScale = (a.wtScale + b.wtScale) / 2.0;
		lambda = (a.lambda + b.lambda) / 2.0;
/*		if (a.wtScale > b.wtScale)
			wtScale = a.wtScale - b.wtScale;
		else
			wtScale = b.wtScale - a.wtScale;
		if (a.lambda > b.lambda)
			lambda = a.lambda - b.lambda;
		else
			lambda = b.lambda - a.lambda;
*/		CxPoint mid = new CxPoint(wtScale, lambda);
		return mid;
	}
	
	private int subdivideEntries(int index, int divisionsRemaining) {
		if (divisionsRemaining == 0)
			return index;
		
		CxPoint curMin = entries.get(index).pointMin;
		CxPoint curMax = entries.get(index+1).pointMin;
		CxPoint pointMid = computeMidpoint(curMin, curMax);
		System.out.println(index + " - " + pointMid);
		
		entries.add(index+1, createCxEntry(pointMid, curMax));
		entries.get(index).pointMax = pointMid;
		
		if (!entries.get(index).lin.equals(entries.get(index+1).lin)) 
			index = subdivideEntries(index, divisionsRemaining-1);
		
		index += 1;
		
		if (!entries.get(index).lin.equals(entries.get(index+1).lin))
			index = subdivideEntries(index, divisionsRemaining-1);
		
		return index;
	}
	
	
}
