package linMap.geneNetwork;

import java.util.*;

/**
 * An <code>Input Layer</code> object represents the layer of nodes in a gene network
 * that recieves external input.  When an input layer is "activated" it simply
 * takes on the new values directly.  An input layer cannot be biased. 
 * @author nic
 */
class InputLayer extends Layer {

	private static final long serialVersionUID = 1405244371881460230L;

	/**
	 * Default input layer constructor.
	 */
	public InputLayer() {
		super();
	}

	/**
	 * Basic input layer constructor
	 * @param id the ID of the new layer
	 * @param size the number of nodes in the new layer
	 */
	public InputLayer(int id, int size) {
		super(id, size, false);
	}

	@Override
	public boolean equals(Object otherObject) {
		return super.equals(otherObject);
	}
	
	@Override
	public String toString() {
		return super.toString();
	}
		
	/* (non-Javadoc)
	 * @see linMap.geneNetwork.Layer#activate(double[])
	 */
	@Override
	protected void activate(Map<Integer, double[]> acts) {
		System.arraycopy(this.currentActivation, 0, this.newActivation, 0, 
				this.currentActivation.length); 
	}

	@Override
	protected void activate(double[] input) {
		System.arraycopy(this.currentActivation, 0, this.newActivation, 0, 
				this.currentActivation.length); 
	}
	
}
