package linMap.geneNetwork;

import junit.framework.TestCase;
import linMap.geneNetwork.Layer;

public abstract class LayerTestTemplate extends TestCase {

	protected Layer layer;
	
	protected static final int LAYER_SIZE = 3;
	
	protected final void setUp() throws Exception {
		super.setUp();
		layer = createLayer(1, LAYER_SIZE, false);
	}

	/**
	 * Factory method. 
	 * Every test of a subclass of Layer must implement this method.
	 * @return a newly created layer object
	 */
	public abstract Layer createLayer(int id, int size, boolean biased);
	
	/**
	 * Test method for 'linMap.geneNetwork.Layer.Layer(int, int, boolean)'.
	 */
	public final void testLayerIntIntBoolean() {
		assertEquals("ID should be 1", 1, layer.getId());
		assertEquals(LAYER_SIZE, layer.getSize());
		assertEquals(false, layer.getBiased());
	}

	/**
	 * Test method for 'linMap.geneNetwork.Layer.getId()'.
	 */
	public final void testGetId() {
		assertEquals(1, layer.getId());
	}

	/**
	 * Test method for 'linMap.geneNetwork.Layer.getBiased()'.
	 */
	public final void testGetBiased() {
		assertEquals(false, layer.getBiased());
	}
	
	/**
	 * Test method for 'linMap.geneNetwork.Layer.activate()'.
	 * Every test of a subclass of Layer must implement this method.  
	 */
	public abstract void testActivate();
	
	/** 
	 * Test method for 'linMap.geneNetwork.Layer.update()
	 */
	public final void testUpdate() {
		double[] activation = { 0.0, 0.1, 0.2 }; 
		layer.newActivation = activation;
		layer.update();
		for (int i=0; i<activation.length; i++) {
			assertEquals(activation[i], layer.currentActivation[i]);
		}
	}
	
	/**
	 * Test method for 'linMap.geneNetwork.Layer.setBiasesTotal(int)'.
	 */
	public final void testSetBiasesTotal() {
		double[][] weights = { { 1, 2, 3 }, { 4, 7, 6 }, { 8, 5, 9 } };
		this.layer.addInput(layer, weights);
		this.layer.setBiasesTotal(0.5);
		assertEquals(-3.0, this.layer.biasValues[0], 1e-8);
		assertEquals(-8.5, this.layer.biasValues[1], 1e-8);
		assertEquals(-11.0, this.layer.biasValues[2], 1e-8);
	}
}
