package linMap.geneNetwork;

import java.util.Random;

/**
 * The <code>NetTools</code> class contains several static convenience functions 
 * pertaining to the <code>Network</code> class.
 * @author nic
 *
 */
public class NetTools {
	
	/**
	 * Create a Simple Recurrent Network (one input and two sigmoidal layers, with 
	 * the central layer being recurrent) with random weights and half-total biases.
	 * Note: this is a convenience function; other network structures can be created
	 * by calling the creation methods directly.
	 * @param iSize
	 * 				number of input nodes
	 * @param hSize
	 * 				number of recurrent (hidden) nodes
	 * @param oSize
	 * 				number of output nodes
	 * @param generator 
	 * 				the <code>Random</code> used to generate
	 * @param weightRange 
	 * 				the standard deviation of the random values
	 * @return the newly created network
	 */
	public static Network createSimpleRecurrentNet(int iSize, int hSize, int oSize,
			Random generator, double weightRange) {
		Network net = new Network();
		int inputId = net.addLayer(iSize, Network.LayerType.INPUT, false);
		int hiddenId = net.addLayer(hSize, Network.LayerType.SIGMOID, true);
		int outputId = net.addLayer(oSize, Network.LayerType.SIGMOID, true);
		net.linkLayers(inputId, hiddenId);
		net.linkLayers(hiddenId, hiddenId);
		net.linkLayers(hiddenId, outputId);
		for (Layer layer : net.nodes) {
			layer.setWeightsRandom(generator, weightRange);
			layer.setBiasesTotal(weightRange);
		}
		return net;
	}
	
	public static Network createSimpleRecurrentNet(int iSize, int hSize, int oSize,
			int seed, double weightRange) {
		Random generator = new Random(seed);
		return createSimpleRecurrentNet(iSize, hSize, oSize, generator, weightRange);
	}
	
	public static Network createSimpleRecurrentNet(NetworkParams netParams) {
		return createSimpleRecurrentNet(netParams.inputNodes, netParams.hiddenNodes,
				netParams.outputNodes, netParams.seed, netParams.weightScale);
	}
}
