package linMap.geneNetwork;

import java.util.*;

/**
 * A <code>Sigmoid Layer</code> object represents a layer of nodes in a gene network
 * whose activation state is updated using a logistic sigmoid function.
 * @author nic
 */
class SigmoidLayer extends Layer {

	private static final long serialVersionUID = 8581649864563978880L;

	/**
	 * Default sigmoid layer constructor.
	 */
	public SigmoidLayer() {
		super();
	}

	/**
	 * Basic sigmoid layer constructor.
	 * @param id the ID of the new layer
	 * @param size the number of nodes in the new layer
	 * @param biased true if the new layer has bias terms
	 */
	public SigmoidLayer(int id, int size, boolean biased) {
		super(id, size, biased);
	}

	@Override
	public boolean equals(Object otherObject) {
		return super.equals(otherObject);
	}
	
	@Override
	public String toString() {
		return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see linMap.geneNetwork.Layer#activate(double[])
	 */
	@Override
	protected void activate(Map<Integer, double[]> acts) {
		this.activate(this.calculateInput(acts));
	}

	@Override
	protected void activate(double[] input) {
		for (int i=0; i<this.currentActivation.length; i++) {
			this.newActivation[i] = sigma(input[i] + this.biasValues[i]);
		}	
	}
	
	/**
	 * Calculate the logistic sigmoid of a value.
	 * @param x
	 * @return the logistic sigmoid of x
	 */
	private double sigma(double x) {
		return 1.0 / (1.0 + Math.exp(-x));
	}
	
}
