package linMap.geneNetwork;

import java.util.*;

import linMap.geneNetwork.InputLayer;
import linMap.geneNetwork.Layer;
import linMap.geneNetwork.SigmoidLayer;

/**
 * @author nic
 *
 */
public class SigmoidLayerTest extends LayerTestTemplate {

	/* (non-Javadoc)
	 * @see linMap.geneNetwork.LayerTestTemplate#createLayer()
	 */
	@Override
	public Layer createLayer(int id, int size, boolean biased) {
		return new SigmoidLayer(id, size, biased);
	}

	/* (non-Javadoc)
	 * @see linMap.geneNetwork.LayerTestTemplate#testActivate()
	 */
	@Override
	public void testActivate() {
		double[] input = new double[LAYER_SIZE];
		input[0] = 0.5;
		this.layer.activate(input);
		assertEquals(0.622459331, layer.newActivation[0], 1e-8);
	}
	
	public void testActivateHashMap() {
		Layer inputLayer = new InputLayer(4, 2);
		double[][] weights = { { 1, 2 }, { 4, 7 }, { 5, 6 } };
		this.layer.addInput(inputLayer, weights);
		double[] input = { 0.2, 0.8 };
		inputLayer.activate(input);
		HashSet<Integer> inputSet = new HashSet<Integer>();
		inputSet.add(4);
		assertEquals(inputSet, this.layer.getInputIds());
		HashMap<Integer, double[]> inputActs = new HashMap<Integer, double[]>();
		
		inputActs.put(4, input);
		double[] calcInput = this.layer.calculateInput(inputActs);
		double[] tgtInput = { 1.8, 6.4, 5.8 };
		for (int i=0; i<tgtInput.length; i++) { 
			assertEquals(tgtInput[i], calcInput[i], 1e-7);
		}
	
		
	}
}
