package linMap.geneNetwork;

import java.util.Random;

import junit.framework.TestCase;
import linMap.geneNetwork.WeightMatrix;

public class WeightMatrixTest extends TestCase {

	private WeightMatrix weightMatrix;
	
	final static int TARGET_SIZE = 2;
	final static int SOURCE_ID = 45;
	final static int SOURCE_SIZE = 3;
	final static double[] SOURCE_ACTIVATION = { 0.1, 0.2, 0.3 };
		
	protected void setUp() throws Exception {
		super.setUp();
		weightMatrix = new WeightMatrix(TARGET_SIZE, SOURCE_SIZE);
	}

	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.WeightMatrix(int, int)'
	 */
	public void testWeightMatrixIntInt() {
		assertEquals(TARGET_SIZE, this.weightMatrix.getTargetSize());
		assertEquals(SOURCE_SIZE, this.weightMatrix.getSourceSize());
	}

	public void testClone() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				double x = i*0.1 + j*0.2;
				this.weightMatrix.weights[i][j] = x;
			}
		}		
		WeightMatrix newMatrix = (WeightMatrix)this.weightMatrix.clone();
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				double x = i*0.1 + j*0.2;
				newMatrix.weights[i][j] = x*2;
			}
		}	
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				double x = i*0.1 + j*0.2;
				assertEquals(x, this.weightMatrix.weights[i][j]);
//				System.out.println("old = " + weightMatrix.getWeight(i, j)
//					+ " : new = " + newMatrix.getWeight(i,j));
			}
		}		
	}
	
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getSourceSize()'
	 */
	public void testGetSourceSize() {
		assertEquals(SOURCE_SIZE, this.weightMatrix.getSourceSize());
	}

	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getTargetSize()'
	 */
	public void testGetTargetSize() {
		assertEquals(TARGET_SIZE, this.weightMatrix.getTargetSize());
	}

	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getWeight(int, int)'
	 */
/*	public void testGetWeight() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				assertEquals(0.0, this.weightMatrix.getWeight(i, j));
			}
		}
	}
*/
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.setWeight(int, int, double)'
	 */
/*	public void testSetWeight() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				double x = i*j;
				this.weightMatrix.setWeight(i, j, x);
			}
		}		
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				double x = i*j;
				assertEquals(x, this.weightMatrix.getWeight(i, j));
			}
		}
	}
*/
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getFixed(int, int)'
	 */
/*	public void testGetFixed() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				assertEquals(false, this.weightMatrix.getFixed(i, j));
			}
		}
	}
*/
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.setFixed(int, int, boolean)'
	 */
/*	public void testSetFixed() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				if ((i*j)%2 == 0) {
					this.weightMatrix.setFixed(i, j, true);
				}
			}
		}		
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				if ((i*j)%2 == 0) {
					assertEquals(true, this.weightMatrix.getFixed(i, j));
				} else {
					assertEquals(false, this.weightMatrix.getFixed(i, j));
				}
			}
		}
	}
*/
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getWeightCount()
	 */
	public void testGetWeightCount() {
		assertEquals(TARGET_SIZE*SOURCE_SIZE, 
				this.weightMatrix.getWeightCount());
	}
	
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.randomiseWeights(Random, 
	 * double)'
	 */
	public void testRandomiseWeights() {
		Random generator = new Random(1234);
		this.weightMatrix.randomise(generator, 1.0);
		Random generator2 = new Random(1234);
		double[][] testWeights = new double[TARGET_SIZE][SOURCE_SIZE];
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				testWeights[i][j] = generator2.nextGaussian();
			}
		}				
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				assertEquals(testWeights[i][j], 
						this.weightMatrix.weights[i][j], 1e-8);
			}
		}
	}
	
	/*
	 * Test method for 'linMap.geneNetwork.WeightMatrix.getWeightedInput()'
	 */
/*	public void testGetWeightedInput() {
		for (int i=0; i<TARGET_SIZE; i++) {
			for (int j=0; j<SOURCE_SIZE; j++) {
				this.weightMatrix.setWeight(i, j, i*3+j);
			}
		}
		double[] targetInput = { 0.8, 2.6 };
		for (int i=0; i<TARGET_SIZE; i++) {
			assertEquals(targetInput[i], 
					this.weightMatrix.getWeightedInput(SOURCE_ACTIVATION)[i], 1e-8);
		}		
	}
*/
}
