package linMap.rulesets.deterministic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/** 
 * A <code>RHS</code> object represents the right-hand side of a rule  
 * @author nic
 *
 */
class RHS {

	protected List<Integer> entries;
	
	public RHS(int left, int right) {
		entries = new ArrayList<Integer>(2);
		entries.add(left);
		entries.add(right);
		Collections.sort(entries);
	}
	
	public String toString() {
		return this.getClass().getName()
		+ "[entries=" + entries
		+ "]";
	}
	
	public void print() {
		for (Integer id : entries) 
			System.out.print(id + " ");
	}
	
	public boolean equals(Object otherObject) {
		if (this == otherObject) return true;
		if (otherObject == null) return false;
		if (this.getClass() != otherObject.getClass()) return false;
		RHS other = (RHS)otherObject;
		return this.entries.equals(other.entries);
	}
	
	public int hashCode() {
		int result = 17;
		for (Integer id : entries)
			result = result*37 + id;
		return result;
	}
}