package linMap.rulesets.deterministic;

/**
 * A <code>Rule</code> represents a single rule in a rule set.
 * @author nic
 */
class Rule {
	/**
	 * 
	 */
	protected int count;
	protected int lhs;
	protected RHS rhs;
	
	public Rule() {
		count = 1;
	}
	
	public String toString() {
		return this.getClass().getName()
		+ "[lhs=" + lhs
		+ ",rhs=" + rhs
		+ ",count=" + count
		+ "]";
	}

	public void print() {
		System.out.print(lhs + " -> ");
		rhs.print();
		System.out.println();
	}
	
	public void incCount() {
		count++;
	}

	public int getCount() {
		return count;
	}

}