package linMap.rulesets.nondeterministic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import linMap.cellLineage.Fate;


/** 
 * A <code>RHS</code> object represents the right-hand side of a rule  
 * @author nic
 *
 */
class RHS {

	private List<Fate> entries;
	
	public RHS(Fate left, Fate right) {
		entries = new ArrayList<Fate>(2);
		entries.add(left);
		entries.add(right);
		Collections.sort(entries);
	}
	
	public void clearTerminalFlags() {
		for (Fate fate : entries) {
			fate.setNonTerminal();
		}
	}

	public String toString() {
		return this.getClass().getName()
		+ "[entries=" + entries
		+ "]";
	}
	
	public void print() {
		for (Fate fate : entries) 
			System.out.print(fate.diff + " ");
	}
	
	public boolean equals(Object otherObject) {
		if (this == otherObject) return true;
		if (otherObject == null) return false;
		if (this.getClass() != otherObject.getClass()) return false;
		RHS other = (RHS)otherObject;
		return this.entries.equals(other.entries);
	}
	
	public int hashCode() {
		int result = 17;
		for (Fate fate : entries)
			result = result*37 + fate.diff;
		return result;
	}
}