package linMap.rulesets.nondeterministic;

import linMap.cellLineage.*;

/**
 * A <code>Rule</code> represents a single rule in a rule set.
 * @author nic
 */
class Rule {
	/**
	 * 
	 */
	private int count;
	protected Fate lhs;
	protected RHS rhs;
	
	public Rule(Cell cell) {
		lhs = (Fate)cell.getFate().clone();
		rhs = new RHS((Fate)cell.getLeft().getFate().clone(), 
				(Fate)cell.getRight().getFate().clone());
		count = 1;
	}
	
	public String toString() {
		return this.getClass().getName()
		+ "[lhs=" + lhs
		+ ",rhs=" + rhs
		+ ",count=" + count
		+ "]";
	}

	public void print() {
		System.out.print(lhs.diff + " -> ");
		rhs.print();
		System.out.println();
	}
	
	public void incCount() {
		count++;
	}

	public int getCount() {
		return count;
	}
	
	public void clearTerminalFlags() {
		lhs.setNonTerminal();
		rhs.clearTerminalFlags();
	}
}