% FIT_SIN - fit a sin with known period to data

function [c,ph,ah,yh] = fit_sin(y,w)

ph_min = -pi;
ph_max = pi;
ph = fminbnd(@(p) cost(y,w,p),ph_min,ph_max);
[c,ah,yh] = cost(y,w,ph);

function [c,ah,yh] = cost(y,w,p)

T = length(y);
ah = y / [ones(1,T); sin(w*(1:T)+p)];
yh = ah(1) + ah(2) * sin(w*(1:T)+p);
c  = norm( y - yh ) / norm(y);