% Test sin fitting
clear all, close all

% Simulation parameters
J = 1:100; % outputs to test
split = 0; % 0 - identify and validate on the whole data, 
           % 1 - split the data into identification/validation parts 

% Load the data
u = load('promotions.dat')'; % [u1 ... uT]
y = load('products.dat')';   % [y1 ... yT]
W = load('influence.dat')';
[m,T] = size(u); [p,T] = size(y);

% Define constants
w1 = 3 * 2*pi / T; % frequencies for the sin term in the model
w2 = 6 * 2*pi / T; % another frequencies for the sin term in the model

% Define identification and validation data
if split
    Ti = round(T * 0.7); Tv = T - Ti;
    ui = u(:,1:Ti);     yi = y(:,1:Ti);
    uv = u(:,Ti+1:end); yv = y(:,Ti+1:end); 
else % use all the data
    Ti = T; Tv = T;
    ui = u; yi = y;
    uv = u; yv = y; 
end    

for j = J
  yj = yi(j,:);
  yvj = yv(j,:);
  [c1,ph1,ah1,yjh1] = fit_sin(yj,w1);
  [c2,ph2,ah2,yjh2] = fit_sin(yj,w2);
  if c1 < c2, 
    yjh = yjh1; w = w1; ph = ph1; ah = ah1;
  else 
    yjh = yjh2; w = w2; ph = ph2; ah = ah2;
  end
  if split
    yhv = ah(1) + ah(2) * sin(w*(Ti+1:T)+ph);
  else
    yhv = yjh;
  end
  % plot the fit
  figure(1)
  plot(1:Tv,yj,'k'), hold on
  plot(1:Tv,yhv,'--b','linewidth',2), hold on
  ax = axis; axis([1 1095 ax(3:4)]), hold off
  set(gca,'fontsize',15)
  xlabel('x'), ylabel('y'), title('t')
  % print -depsc challengef1.eps
  fprintf('Output %d\n', j)
  pause
end

