function [Nx,Ny,index]=ContourGeneratorN(e,X,Y,Ls)
%e is a binary image (detected contour)  (1=contour, 0=background) 
%Nx, and Ny are the x and y-coordinates (columns and rows) respectively of the contour sequentially
%index contains the index starting a new contour if any; i.e. from 1: index(1)-1 corresponds to 
%pixels(with distance less than Ls) close to the contour will be eliminated
%the first object. The second object is from index(1):index(2)-1 and so on.
%if X or Y or both are zero, then the algorithm starts from an arbitrary point otherwise 
%it starts from the point (X,Y) where X and Y are column and row of the point respectively
[r,c]=find(e==1);
x=c;
y=r;
m=length(x);
cnt=1;
L=1;
if ((X==0)|(Y==0))
    Nx(cnt)=x(1);
    Ny(cnt)=y(1);
else
    Nx(cnt)=X;
    Ny(cnt)=Y;
end
s=sqrt((y-Ny(cnt)).^2+(x-Nx(cnt)).^2);
I=zeros(m,4);
I(:,1)=x;
I(:,2)=y;
I(:,3)=s;
N=m;
%figure(2)
%clf
%imshow(e)
%hold
while(N>0)
    cnt=cnt+1;
    I(L,:)=[];
    [sI,id]=sortrows(I,3);
    Nx(cnt)=sI(1,1);
    Ny(cnt)=sI(1,2);
    L=id(1);
    s=sqrt((I(:,2)-Ny(cnt)).^2+(I(:,1)-Nx(cnt)).^2);
    In=[I(:,1) I(:,2) s s-I(:,3)];
    %%%%%%%%%%%%%%%%%%%%
    [M,BB]=size(I);
    cnt2=1;
    if(abs(mean(I(:,3))-mean(In(:,3)))<=Ls)    
        for i=1:M
            if(I(i,4)*In(i,4)<0)
                if(In(i,3)<=Ls)%pixels(with distance less than Ls) close to the contour will be eliminated              
                    P(cnt2)=i;
                    cnt2=cnt2+1;
                end
            end
        end
    else
        In(:,4)=zeros(length(In(:,4)),1);
    end
    if(exist('P','var'))
        PP=length(P);
        for i=PP:-1:1
            In(P(i),:)=[];
        end
    end
    %%%%%%%%%%%%%%%%%%%%
    I=In;
    clear In P
    N=size(I,1)-1;
    if(N>0)
        [sI,id]=sortrows(I,3);
        Nx(cnt)=sI(1,1);
        Ny(cnt)=sI(1,2);
        L=id(1);
    end
 %   plot(Nx,Ny,'rx')
 %   pause
end
N=length(Nx);
s=zeros(N,1);
for i=2:N
    s(i)=sqrt((Nx(i)-Nx(i-1))^2+(Ny(i)-Ny(i-1))^2);
end
Ms=mean(s);
cnt=1;
index=0;
for i=1:N
    if(s(i)>10*Ms)
        index(cnt)=i;
        cnt=cnt+1;
    end
end
T=1;

