% Example of section V

clear all

% Images obtained from the pdf file of A.~Tsai, et al., A shape-based
% approach to the segmentation of medical imagery using level sets, IEEE
% Trans. on Medical Imaging, vol.~22, pp. 137--154, 2003.

%%%% Paramters for ContourGeneratorN
ContourGap = 4;   % this is the maximum number of gap points between two successive contour points.
Stdv = 2;         % this is the standard deviation of the Gaussian filter used by Canny edge detector.
FirstRow = 0;     % the first contour point row index this is normaly kept as it is ;
FirstCol = 0;     % the first contour point column index this is normaly kept;

FltrSize = Stdv * 6; % this is the Gaussian filter size, this achieves about 99% of the signal.

im1 = imread('bar-403.ppm');
im2 = imread('bar-404.ppm');
im3 = imread('bar-670.ppm');
im4 = imread('bar-671.ppm');
im5 = imread('bar-672.ppm');
im6 = imread('bar-673.ppm');

% Convert to binary
im = im2bw(im1);
%colormap('gray')
%image(255*im)

% Very ad hock splitting
for i = 1:12
    ims{i} = im(:,1:115);
    t = min(120,size(im,2));
    im(:,1:t) = [];
    if ~isempty(im)
        while 1
            if im(end,1)
                im(:,1) = [];
            else
                break
            end
        end
    end
    
    %colormap('gray')
    %image(255*ims{i})
    %pause
end

% Select two images for the experiemnt
figure(1), 
imshow(ims{1}), truesize
title('t')
print -deps distf6.eps
figure(2), 
imshow(ims{10}), truesize
title('t')
print -deps distf7.eps

% Select np sequential boundary points 
np = 300;
for i = [1,10]
    bim{i} = canny(double(ims{i}),Stdv,FltrSize,0.01);
    [Nx{i},Ny{i},index] = ContourGeneratorN(bim{i},FirstRow,FirstCol,ContourGap);
    plot(Ny{i}(:),Nx{i}(:),'rs'), hold on
    plot(Ny{i}(1),Nx{i}(1),'rs','linewidth',5)
    % spline
    N = length(Nx{i});
    Nxs{i} = spline(1:N,Nx{i},linspace(1,N,np));
    Nys{i} = spline(1:N,Ny{i},linspace(1,N,np));
    plot(Nys{i}(:),Nxs{i}(:),'bo'), hold on
    plot(Nys{i}(1),Nxs{i}(1),'bo','linewidth',5)
    %pause
end

% Solve the alignment problem
x = [Nxs{1}; Nys{1}];
y = [Nxs{10}; Nys{10}];
d = zeros(1,np);
tic,
for k = 1:np
    d(k) = dist(circshift(x,[0 k]),y);
end
comp_time = toc;
[ds,ks] = min(d);
[d_,a,s,r,xh]  = dist(circshift(x,[0 ks]),y);

figure(3)
plot(1:np,d, 'o','markersize',5,'linewidth',1), hold on
plot(ks,ds,'xr','markersize',15,'linewidth',2), hold on
title('t'), xlabel('x'), ylabel('y')
set(gca,'fontsize',20)
print -depsc distf5.eps

figure(4)
plot(x(1,:),110-x(2,:),'ro','markersize',5,'linewidth',2), hold on
plot(x(1,1),110-x(2,1),'rX','markersize',20,'linewidth',3)
plot(y(1,:),110-y(2,:),'k.','markersize',10,'linewidth',1)
plot(y(1,1),110-y(2,1),'kX','markersize',20,'linewidth',3)
plot(xh(1,:),110-xh(2,:),'bx','markersize',5,'linewidth',2)
plot(xh(1,1),110-xh(2,1),'bX','markersize',20,'linewidth',3)
set(gca,'fontsize',20)
axis equal, axis([20 100 0 110]), axis off
%set(gca,'ytick',[-1 0 1 2])
print -depsc distf4.eps

figure(5), 
T = maketform('affine',[s*[cos(-r) -sin(-r); sin(-r) cos(-r)]; a']);
tim = imtransform(ims{10},T,'XData',[1 115],'YData',[1 115]);
imshow(tim), truesize
title('t')
print -deps distf8.eps

