function e=nms(mag, fx, fy)

[rows,cols]=size(mag);


% clear image borders
for c=1:cols, e(1,c)=0; end;
for c=1:cols, e(rows,c)=0; end;
for r=1:rows, e(r,1)=0; end;
for r=1:rows, e(r,cols)=0; end;


for r= 2:1:rows-1, for c=2:1:cols-1, 

z0 = mag(r,c);
if(z0 == 0)
	e(r,c) =0;
else
	zx =  fx(r,c);
	zy =  fy(r,c);

	if (fx(r,c)>= 0)
		if (fy(r,c)>= 0)
			if (fx(r,c) >= fy(r,c))
				% 1 Left point 
				z1 = mag(r,c-1);
				z2 = mag(r-1,c-1);
				m1 = (z1 - z0)*zx + (z2 - z1)*zy;
				% Right point 
				z1 = mag(r,c+1);
				z2 = mag(r+1,c+1);
				m2 = (z1 - z0)*zx + (z2 - z1)*zy;
			else
				% 2 Left point 
				z1 = mag(r-1,c);
				z2 = mag(r-1,c-1);
				m1 = (z2 - z1)*zx + (z1 - z0)*zy;
				% Right point 
				z1 = mag(r+1,c);
				z2 = mag(r+1,c+1);
				m2 = (z2 - z1)*zx + (z1 - z0)*zy;
			end
		else
			if (fx(r,c) >= -fy(r,c))
				% 3  Left point 
				z1 = mag(r,c-1);
				z2 = mag(r+1,c-1);
				m1 = (z1 - z0)*zx + (z1 - z2)*zy;
				% Right point 
				z1 = mag(r,c+1);
				z2 = mag(r-1,c+1);
				m2 = (z1 - z0)*zx + (z1 - z2)*zy;
			else
				% 4 Left point 
				z1 = mag(r+1,c);
				z2 = mag(r+1,c-1);
				m1 = (z2 - z1)*zx + (z0 - z1)*zy;
				% Right point 
				z1 = mag(r-1,c);
				z2 = mag(r-1,c+1);
				m2 = (z2 - z1)*zx  + (z0 - z1)*zy;
			end
		end
	else
		if (fy(r,c) >= 0)
			if (-fx(r,c) >= fy(r,c))
				% 5 Left point 
				z1 = mag(r,c+1);
				z2 = mag(r-1,c+1);
				m1 = (z0 - z1)*zx + (z2 - z1)*zy;
				% Right point 
				z1 = mag(r,c-1);
				z2 = mag(r+1,c-1);
				m2 = (z0 - z1)*zx + (z2 - z1)*zy;
			else
				% 6 Left point 
				z1 = mag(r-1,c);
				z2 = mag(r-1,c+1);
				m1 = (z1 - z2)*zx + (z1 - z0)*zy;
				% Right point 
				z1 = mag(r+1,c);
				z2 = mag(r+1,c-1);
				m2 = (z1 - z2)*zx + (z1 - z0)*zy;
			end
		else
			if (-fx(r,c) >= -fy(r,c))
				% 7 Left point 
				z1 = mag(r,c+1);
				z2 = mag(r+1,c+1);
				m1 = (z0 - z1)*zx + (z1 - z2)*zy;
				% Right point 
				z1 = mag(r,c-1);
				z2 = mag(r-1,c-1);
				m2 = (z0 - z1)*zx + (z1 - z2)*zy;
			else
				% 8 Left point 
				z1 = mag(r+1,c);
				z2 = mag(r+1,c+1);
				m1 = (z1 - z2)*zx + (z0 - z1)*zy;
				% Right point 
				z1 = mag(r-1,c);
				z2 = mag(r-1,c-1);
				m2 = (z1 - z2)*zx + (z0 - z1)*zy;
			end
		end
	end

	% Now determine if the current point is a maximum point 
	if ((m1 >= 0.0) | (m2 > 0.0))
		e(r,c) = 0;
	else
		e(r,c) =1; %possible edge
	end
end	%end of if statement


end	%end of inner loop
end	%end of outer loop



