% Examples 1

p = [1     0    -1    -1     0     1
     1     1     1    -1    -1    -1];

q = [2.5    2.6    2.5    3.5    3.4    3.5
     1.5    1.0    0.5    0.5    1.0    1.5];

figure(1)
fill(p(1,:),p(2,:),'g--'), hold on
plot(p(1,:),p(2,:),'ko','markersize',4,'linewidth',4)
fill(q(1,:),q(2,:),'r--'), hold on
plot(q(1,:),q(2,:),'ko','markersize',4,'linewidth',4)
title('t'), xlabel('x'), ylabel('y')
set(gca,'fontsize',15)
axis equal, axis([-1.5 4 -1.5 2])
%print -depsc distf1.eps

[d,ah,sh,th,ph] = dist1(p,q);

figure(2)
fill(p(1,:),p(2,:),'g--'), hold on
plot(p(1,:),p(2,:),'ko','markersize',4,'linewidth',4),
fill(ph(1,:),ph(2,:),'r--'),
plot(ph(1,:),ph(2,:),'ko','markersize',4,'linewidth',4)
title('t'), xlabel('x'), ylabel('y')
set(gca,'fontsize',20)
axis equal, axis([-1.5 4 -1.5 2])
set(gca,'ytick',[-1 0 1 2])
%print -depsc distf2.eps

[d,ah,sh,th,qh] = dist1(q,p);

figure(3)
fill(qh(1,:),qh(2,:),'g--'), hold on
plot(qh(1,:),qh(2,:),'ko','markersize',4,'linewidth',4)
fill(q(1,:),q(2,:),'r--'),
plot(q(1,:),q(2,:),'ko','markersize',4,'linewidth',4),
title('t'), xlabel('x'), ylabel('y')
set(gca,'fontsize',20)
axis equal, axis([-1.5 4 -1.5 2])
set(gca,'ytick',[-1 0 1 2])
%print -depsc distf3.eps

% Examples 2

% Center and scale the data
N = size(p,2);
pc = p - mean(p,2) * ones(1,N); pcn = pc / norm(pc,'fro');
qc = q - mean(q,2) * ones(1,N); qcn = qc / norm(qc,'fro');

tr = 0.3;
pcr = [cos(tr) -sin(tr); sin(tr) cos(tr)] * pc;
qcr = [cos(tr) -sin(tr); sin(tr) cos(tr)] * qc;

[dist1(pc,qc) dist1(pcr,qcr)]

[dist1(pcn,qcn) dist1(qcn,pcn)]

% Examples 3
 
[dist1(p,q) dist1(q,p)]
[dist(p,q) dist(q,p)]

% Test with random data

N = 1e6;

p = rand(2,N); a = rand(2,1); t = randn * 2 * pi; s = rand * 10;
p = s * [cos(t) -sin(t); sin(t) cos(t)] * p + a(:,ones(1,N));

q = rand(2,N); a = rand(2,1); t = randn * 2 * pi; s = rand * 10;
q = s * [cos(t) -sin(t); sin(t) cos(t)] * q + a(:,ones(1,N));

a = rand(2,1); t = randn * 2 * pi; s = rand * 10;
Ap = s * [cos(t) -sin(t); sin(t) cos(t)] * p + a(:,ones(1,N));
Aq = s * [cos(t) -sin(t); sin(t) cos(t)] * q + a(:,ones(1,N));

format long, [dist(p,q) dist(q,p) dist(Ap,Aq)], format

% Plot of the computation time

np = 20; t = zeros(1,np);
NN = round(linspace(10,10^5,np));
for i = 1:np
    tic, d = dist(p(:,1:NN(i)),q(:,1:NN(i))); t(i) = toc;
end

figure(4)
plot(NN,t,'-o','linewidth',2)
title('t'), xlabel('x'), ylabel('y')
set(gca,'fontsize',20)
%axis([NN(1) NN(end) 0 0.071])
%print -depsc distf9.eps

tic, d = dist(p,q); t_million = toc